<?php

//header("Content-type:text-plain; charset=UTF-8");
error_reporting(E_ALL); 
ini_set('display_errors', 1);

require_once 'inc/header.inc.php';
require_once 'vendors/tcpdf/tcpdf.php';

//check auth username
$login = $db->getRow2('person_login','username',$_COOKIE[PREFIX_COOKIE."USERNAME"],'token',$_COOKIE[PREFIX_COOKIE."TOKEN"]);

//ตรวจสอบข้อมูล get ต้องมาครบ
if( empty($_GET['hr_move_id']) || empty($_GET['token']) || empty($_GET['hr_move_round_id']) ) {
    echo '<div style="margin-top:20px; text-align:center; color:red;">ข้อมูลไม่ครบ หรือท่านยังไม่ได้ทำการ<br>ยืนยันข้อมูลจนครบตั้งแต่ขั้นตอน 1-7</div>';
    exit();
}


$sql = "
    SELECT
        a.hr_move_id,
        a.hr_move_round_id,
        a.year_budget,
        a.person_id,
        a.lock_status,
        a.approve_status,

        b.gov_id,
        b.position_id,
        b.position_level_id,
        b.fname,
        b.lname,
        b.age,
        b.write_gov_id,
        b.write_date,
        b.start_work_date,
        b.gov_id,
        b.gov_work_name,
        b.gov_start_work_date,
        b.salary,
        b.year_work,
        b.month_work,
        b.description,
        b.special_skill,
            b1.prename,
            b2.name as first_changwat_name,
            b3.position_name,
            b4.position_level_name,
            b4.position_level_name_full,

        c.*,
            c1.name as marry_type_name,
            c2.name as birth_changwat_name,
            c3.name as home_type_name,
            c4.name as parent_type_name,
						
        d.*,
			 
        e.gov_id_1,
        e.gov_other_name_1,
        e.start_date_1,
        e.stop_date_1,
        e.position_name_1,
        e.gov_id_2,
        e.gov_other_name_2,
        e.start_date_2,
        e.stop_date_2,
        e.position_name_2,
        e.gov_id_3,
        e.gov_other_name_3,
        e.start_date_3,
        e.stop_date_3,
        e.position_name_3,
            eg1.name as gov_name_1,
            eg2.name as gov_name_2,
            eg3.name as gov_name_3,
        
        f.person_type_id,
        f.position_move_type_id,
        f.position_group_code,
        f.current_position_id,
        f.current_position_level_id,
        f.position_id,
        f.position_level_id,
        f.changwat_id_1,
        f.building_id_1,
        f.ampur_id_1,
        f.gov_id_active_1,
        f.gov_id_1_1,
        f.gov_id_1_2,
        f.gov_id_1_3,
        f.changwat_id_2,
        f.building_id_2,
        f.ampur_id_2,
        f.gov_id_active_2,
        f.gov_id_2_1,
        f.gov_id_2_2,
        f.gov_id_2_3,
        f.changwat_id_3,
        f.building_id_3,
        f.ampur_id_3,
        f.gov_id_active_3,
        f.gov_id_3_1,
        f.gov_id_3_2,
        f.gov_id_3_3,
        f.changwat_id_4,
        f.building_id_4,
        f.ampur_id_4,
        f.gov_id_active_4,
        f.gov_id_4_1,
        f.gov_id_4_2,
        f.gov_id_4_3,
        f.changwat_id_5,
        f.building_id_5,
        f.ampur_id_5,
        f.gov_id_active_5,
        f.gov_id_5_1,
        f.gov_id_5_2,
        f.gov_id_5_3,
        f.changwat_id_6,
        f.building_id_6,
        f.ampur_id_6,
        f.gov_id_active_6,
        f.gov_id_6_1,
        f.gov_id_6_2,
        f.gov_id_6_3,
        f.changwat_id_7,
        f.building_id_7,
        f.ampur_id_7,
        f.gov_id_active_7,
        f.gov_id_7_1,
        f.gov_id_7_2,
        f.gov_id_7_3,
        f.confirm_stay_type,
            f1.position_name AS target_position_name,
            f2.position_level_name AS target_position_level_name,
            f2.position_level_name_full AS target_position_level_name_full,
       
        g.description as move_detail_description,
        
        b.complete as step1_complete,
        c.complete as step2_complete,
        d.complete as step3_complete,
        e.complete as step4_complete,
        f.complete as step5_complete,
        g.complete as step6_complete,
        h.complete as step7_complete,
        i.complete as step8_complete,

        j.hr_move_print_config_id,
        j.header1_new_page,
        j.header2_new_page,
        j.header3_new_page,
        j.header4_new_page,
        j.header5_new_page,
        j.header6_new_page,
        j.header7_new_page,
        j.header8_new_page,
        j.header9_new_page,
        j.header10_new_page,

        b.updated_date as step1_updated_date,
        c.updated_date as step2_updated_date,
        d.updated_date as step3_updated_date,
        e.updated_date as step4_updated_date,
        f.updated_date as step5_updated_date,
        g.updated_date as step6_updated_date,
        h.updated_date as step7_updated_date,
        i.updated_date as step8_updated_date,

        k.start_date AS round_start_date,
        k.expire_date AS round_expire_date

    FROM 
        hr_move a
        LEFT JOIN hr_move_current b ON a.hr_move_id=b.hr_move_id
            LEFT JOIN l_prename b1 ON b.prename_id=b1.prename_id
            LEFT JOIN l_changwat b2 ON b.first_changwat_id=b2.changwat_id
            LEFT JOIN l_position b3 ON b.position_id=b3.position_id
            LEFT JOIN l_position_level b4 ON b.position_level_id=b4.position_level_id

        LEFT JOIN hr_move_family c ON a.hr_move_id=c.hr_move_id
		    LEFT JOIN hr_move_marry_type c1 ON c.hr_move_marry_type_id=c1.hr_move_marry_type_id				
            LEFT JOIN l_changwat c2 ON c.changwat_id=c2.changwat_id
            LEFT JOIN hr_move_family_home_type c3 ON c.hr_move_family_home_type_id=c3.hr_move_family_home_type_id
            LEFT JOIN hr_move_family_parent_type c4 ON c.hr_move_family_parent_type_id=c4.hr_move_family_parent_type_id
					
		LEFT JOIN hr_move_meeting d ON a.hr_move_id=d.hr_move_id

        LEFT JOIN hr_move_history e ON a.hr_move_id=e.hr_move_id
            LEFT JOIN gov eg1 ON e.gov_id_1=eg1.gov_id
            LEFT JOIN gov eg2 ON e.gov_id_2=eg2.gov_id
            LEFT JOIN gov eg3 ON e.gov_id_3=eg3.gov_id
            
        LEFT JOIN hr_move_target f ON a.hr_move_id=f.hr_move_id
            LEFT JOIN l_position f1 ON f.position_id=f1.position_id
            LEFT JOIN l_position_level f2 ON f.position_level_id=f2.position_level_id

        LEFT JOIN hr_move_detail g ON a.hr_move_id=g.hr_move_id
        LEFT JOIN hr_move_file h ON a.hr_move_id=h.hr_move_id
        LEFT JOIN hr_move_print i ON a.hr_move_id=i.hr_move_id
        LEFT JOIN hr_move_print_config j ON a.hr_move_id=j.hr_move_id

        LEFT JOIN hr_move_round k ON a.hr_move_round_id=k.hr_move_round_id

    WHERE
        a.hr_move_id=:hr_move_id
        AND a.hr_move_round_id=:hr_move_round_id
        AND a.token=:token
        AND a.status=1
        AND b.complete = 1
        AND c.complete = 1
        AND d.complete = 1
        AND e.complete = 1
        AND f.complete = 1
        AND g.complete = 1
        AND h.complete = 1
        AND k.status = 1

    LIMIT
        0,1
";
$stmt = $conn->prepare($sql);
$stmt->bindParam(':hr_move_id',$_GET['hr_move_id']);
$stmt->bindParam(':hr_move_round_id',$_GET['hr_move_round_id']);
$stmt->bindParam(':token',$_GET['token']);
$stmt->execute();

if($stmt->rowCount()  == 0){
    echo '<div style="margin-top:20px; text-align:center; color:red;">ข้อมูลไม่ถูกต้อง หรือท่านยังไม่ได้ทำการ<br>ยืนยันข้อมูลจนครบตั้งแต่ขั้นตอน 1-7</div>';
    exit();

}else{

    // ------ ดึงข้อมูล
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    // ------- กรณีระบบ ล็อค
    if($result['lock_status'] == 1){
        echo '<div style="margin-top:20px; text-align:center; color:red;">ไม่สามารถพิมพ์ได้<br>เนื่องจากระบบล็อค</div>';
        exit();
    }

    // ------- เช็คว่า round_id นี้หมดอายุแล้วหรือยัง และ สถานะเป็นอยู่ระหว่างดำเนินการ หรือจัดส่ง ยังไม่เปลี่ยนเป็น สบบ.รับเอกสารแล้ว ก็จะพิมพ์ไม่ได้
    if( date('Y-m-d', time()) >  date('Y-m-d', strtotime($result['round_expire_date'])) && $result['approve_status'] != 1 ){
        echo '<div style="margin-top:20px; text-align:center; color:red;">ไม่สามารถพิมพ์ได้<br>เนื่องจากหมดเขตการเขียนย้ายเมื่อวันที่<br>'. dateintertothaifull($result['round_expire_date']).' เที่ยงคืน</div>';
        exit();
    }

    // ------- ถ้าสถานะเป็น สบบ.รับเอกสารแล้ว
    // ------- ทุกครั้งที่พิมพ์ จะเป็นการขอแก้ไข
    $show_edit_after_complete = '';
    if( $result['approve_status'] == 1 ){
        $show_edit_after_complete = ' (เอกสารแนบที่มีการแก้ไขข้อมูล)';
    }

    //บันทึกข้อมูล ว่ามีการ พิมพ์เอกสารแล้ว
    //move-print.php?hr_move_id='.$result['hr_move_id']
    $_POST['by_date'] = date('Y-m-d H:i:s');
    $_POST['by_username'] = $_COOKIE[PREFIX_COOKIE.'USERNAME'];
    $_POST['complete'] = '1';
    $sql = "
        DELETE FROM
            hr_move_print
        WHERE
            hr_move_id=:hr_move_id;

        INSERT INTO
            hr_move_print(
                hr_move_id,
                created_date,
                created_by,
                updated_date,
                updated_by,
                complete
            ) value(
                :hr_move_id,
                :created_date,
                :created_by,
                :updated_date,
                :updated_by,
                :complete
            )
        ;
    ";
    try {
        $stmt2 = $conn->prepare($sql);
        $stmt2->bindParam(':hr_move_id', $_GET['hr_move_id']);
        $stmt2->bindParam(':created_date', $_POST['by_date']);
        $stmt2->bindParam(':created_by', $_POST['by_username']);
        $stmt2->bindParam(':updated_date', $_POST['by_date']);
        $stmt2->bindParam(':updated_by', $_POST['by_username']);
        $stmt2->bindParam(':complete', $_POST['complete']);
        $stmt2->execute();
    }catch (Exception $e) {
        echo 'เกิดข้อผิดพลาด กรุณาทดลองปริ้นใหม่อีกครั้ง';
        exit();
    }


    
    //ถ้ากรณีเป็น พนักงานราชการ ระดับจะไม่มีระดับ
    if($result['person_type_id'] == 4){ //พนักงานราชการ
        $result['position_level_name'] = '';
        $result['target_position_level_name'] = '';        
    }elseif($result['person_type_id'] == 3){ //กรณีเป็น ลูกจ้างประจำ จะต้องเว้นวรรคด้านหน้า ระดับให้ห่างกับตำแหน่ง
        $result['position_level_name'] = ' '.$result['position_level_name'];
        $result['target_position_level_name'] = ' '.$result['target_position_level_name'];
    }

    //ดึงข้อมูลหน่วยงานทั้งหมด
    $sql = "SELECT * FROM gov";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $allgov = $stmt->fetchAll(PDO::FETCH_ASSOC);

    //ดึงข้อมูลจังหวัด
    $sql = "SELECT * FROM l_changwat_for_move";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $allchangwat = $stmt->fetchAll(PDO::FETCH_ASSOC);

    //ดึงข้อมูลอำเภอ
    $sql = "SELECT * FROM l_ampur_for_move";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $allampur = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    //ดึงข้อมูลอาคาร
    $sql = "SELECT * FROM l_building";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $allbuilding = $stmt->fetchAll(PDO::FETCH_ASSOC);

}


// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {  

    //Page header
    //====== STRT แสดงพื้นหลังตัวอย่าง
    /*
    public function Header() {
        $image_header = "assets/icon/example.png";
        $this->SetAlpha(0.6);
        $this->SetY(3);
        $this->Image($image_header, '10', '30', '190');        
    }
    */
    //====== STOP แสดงพื้นหลังตัวอย่าง

    //    Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        global $show_edit_after_complete;
        $this->SetFont('thsarabunnew', '', 16,'',false);
        $this->SetY(-17);
        $this->Cell(67, -17, 'พิมพ์จากระบบเมื่อ : '. shortdatetimeintertothai($_POST['by_date']) . $show_edit_after_complete , 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(133, -17, 'หน้า : '. $this->getAliasNumPage() .'/'. $this->getAliasNbPages() , 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }

}

// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// create new PDF document
// $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// remove default header/footer
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(true);

//หน่วยเป็น mm=มิลลิเมตร
$top = 15;
$left = 15;
$right = 10;

$pdf->SetMargins($left, $top, $right);
$pdf->SetAutoPageBreak(TRUE, 20); //Auto Set Margin Bottom


//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

//set font
//นำฟอนต์ที่ต้องการใช้ไปไว้ใน folder tcpdf->fonts
//$fontname = $pdf->addTTFfont('fonts\thsarabun\thsarabunnew-webfont.ttf','',32);
//$pdf->SetFont('thsarabunnew', '', 16);

//ช่องว่าง
$spacebar = '';
$space = array();
for($i=0;$i<=30;$i++){
    $spacebar .= '&nbsp;';
    $space[$i] = $spacebar;
}

//add a page
$pdf->AddPage('P','A4'); //P=แนวตั้ง L=แนวนอน
// $pdf->SetAlpha(0.05); //opacity ให้ภาพเบลอ
// get the current page break margin
$bMargin = $pdf->getBreakMargin();
// get current auto-page-break mode
$auto_page_break = $pdf->getAutoPageBreak();
// disable auto-page-break
$pdf->SetAutoPageBreak(false, 0);
// set bacground image
// $img_file = 'images/logo-only.png';
// $pdf->Image($img_file, 65, 80, 80, 0, '', '', '', true, 182);
// restore auto-page-break status
$pdf->SetAutoPageBreak($auto_page_break, $bMargin);


// ================== EXAMPLE FILE ======================
// $img_example = 'assets/icon/example.png';
// $pdf->SetAlpha(0.6); //opacity ให้ภาพเบลอ
// $pdf->Image($img_example, 14, 40, 185, 0, '', '', '', true, 100);
// ================== EXAMPLE FILE ======================


// set the starting point for the page content\
$pdf->SetAlpha(1);
$pdf->setPageMark();


// บังคับ default ก่อน
// หากมีการ ร้องขอจากผู้ใช้งานให้ทำการ config การขึ้นหน้าใหม่ได้ ให้ดำเนินการ กลับไปใช้ modal config เหมือนเดิม
if($result['hr_move_print_config_id'] == ''){
    $result['header1_new_page'] = 0;
    $result['header2_new_page'] = 0;
    $result['header3_new_page'] = 1;
    $result['header4_new_page'] = 0;
    $result['header5_new_page'] = 0;
    $result['header6_new_page'] = 1;
    $result['header7_new_page'] = 0;
    $result['header8_new_page'] = 0;
    $result['header9_new_page'] = 0;
    $result['header10_new_page'] = 0;
}


// ===================================================================================
// ===================================== หน้า 1 =======================================
// ===================================================================================

//ดึงข้อมูลเขียนที่
$show_write_gov_name = '';
foreach($allgov as $gov){
    if($gov['gov_id'] == $result['write_gov_id']){
        $show_write_gov_name = $gov['name'];
        break;
    }
}
$strtotime_write_date = strtotime($result['write_date']); //วันที่เขียน
$strtotime_start_work_date = strtotime($result['start_work_date']); //วันที่เริ่มบรรจุ

//สังกัดที่ปฏิบัติงานอยู่ปัจจุบัน
$show_gov_name = '';
foreach($allgov as $gov){
    if($gov['gov_id'] == $result['gov_id']){
        $show_gov_name = $gov['name'];
        break;
    }
}
$strtotime_gov_start_work_date = strtotime($result['gov_start_work_date']); //เริ่มทำงานสถานที่ปัจจุบันเมื่อวันที่

/*
if($result['hr_move_current_type_id'] == 3){
    $form_title = 'แบบขอโยกย้าย';
}else{
    $form_title = 'แบบข้อมูลประกอบการพิจารณาบริหารงานบุคคล';
}
*/
$form_title = 'แบบข้อมูลประกอบการพิจารณาโยกย้าย'; //ปี 2565 ใช้เฉพาะข้อมูบประกอบการพิจารณา

//หัวเรื่อง
$pdf->SetFont('thsarabunnew', '', 24);
$html = '
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr><td align="center" style="font-size:18px"><b>'.$form_title.'</b></td></tr>
    </table>
    <table width="100%" cellspacing="-5" cellpadding="-5" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr><td align="right" style="font-size:16px">เขียนที่ '. thainumber($show_write_gov_name) .'</td></tr>
        <tr><td align="right" style="font-size:16px">วันที่ '. thainumber(date('j',$strtotime_write_date)) . ' เดือน ' . $thaimontharr[date('m',$strtotime_write_date)] . ' พ.ศ. '  . thainumber((date('Y',$strtotime_write_date)+543)) .'</td></tr>
    </table>    

    <table width="100%" cellspacing="-6" cellpadding="-6" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr><td align="left" style="font-size:16px">เรื่อง '.$space[9].'ข้อมูลประกอบการพิจารณาโยกย้ายของข้าราชการธุรการสำนักงานอัยการสูงสุด</td></tr>
    </table>

    <table width="100%" cellspacing="-6" cellpadding="-6" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr><td align="left" style="font-size:16px">กราบเรียน    อัยการสูงสุด</td></tr>
    </table>

    <table width="100%" cellspacing="-6" cellpadding="-6" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr><td align="left" style="font-size:16px">'.$space[16].'ตามที่สำนักงานอัยการสูงสุดจะดำเนินการพิจารณาโยกย้าย เพื่อประโยชน์ของทางราชการและเพื่อการพัฒนา<br>เพิ่มพูนศักยภาพและประสบการณ์ นั้น<br>'.$space[16].'ข้าพเจ้าขอแจ้งข้อมูล
        เพื่อใช้ประกอบการพิจารณา ดังต่อไปนี้</td></tr>
    </table>
';
$pdf->writeHTML($html, false, false, true, false, '');



// ============================== 1.ตำแหน่งหน้าที่ในปัจจุบัน (hr_move_current) =========================================

//คำนวณหา รวมระยะเวลาปฏิบัติราชการ ปี เดือน
$result['cal_year'] = calDateDiffYearOnlyRatchakarn($result['gov_start_work_date']);
$result['cal_month'] = calDateDiffMonthOnlyRatchakarn($result['gov_start_work_date']);

$html = '
    <table width="100%" cellspacing="-6" cellpadding="-6" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr><td align="left" style="font-size:16px">'.$space[16].'<b>๑. <u>ตำแหน่งหน้าที่ในปัจจุบัน</u></b></td></tr>
    </table>

    <table width="100%" cellspacing="-7" cellpadding="-7" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" width="100%" border="0" style="font-size:16px">
        <tr>
            <td colspan="2" align="left">'.$space[20].'ข้าพเจ้า'.$space[2]. $result['prename'] . $result['fname'] . $space[2] . $result['lname'] . $space[3] . 'อายุ' . $space[3] . thainumber($result['age']) . ' ปี</td>
        </tr>
        <tr>
            <td colspan="2" align="left">'.'พื้นที่ที่รับราชการครั้งแรกจังหวัด'.$space[2]. $result['first_changwat_name'] . '</td>
        </tr>
        <tr>
            <td colspan="2" align="left">'.'เข้ารับราชการสังกัดสำนักงานอัยการสูงสุด&nbsp;เมื่อวันที่'. $space[2] .thainumber(date('j',$strtotime_start_work_date)) . '&nbsp;&nbsp;เดือน ' . $thaimontharr[date('m',$strtotime_start_work_date)] . '&nbsp;&nbsp;พ.ศ. ' . thainumber(date('Y',$strtotime_start_work_date)+543) . '</td>
        </tr>
        <tr>
            <td colspan="2" align="left">'.'ปัจจุบันดำรงตำแหน่ง'.$space[2]. thainumber($result['position_name']) . thainumber($result['position_level_name']) . $space[3] . 'เงินเดือน' . $space[1] . thainumber(number_format($result['salary'],0)) . ' บาท</td>
        </tr>
        <tr>
            <td colspan="2" align="left">'.'สังกัดสำนักงาน'.$space[2]. thainumber($show_gov_name) . '</td>
        </tr>
        <tr>
            <td colspan="2" align="left">'.'ปฏิบัติราชการที่'.$space[2]. thainumber($result['gov_work_name']) . '</td>
        </tr>
        <tr>
            <td colspan="2" align="left">เมื่อวันที่&nbsp;'.$space[1]. thainumber(date('j',$strtotime_gov_start_work_date)) . '&nbsp;&nbsp;เดือน ' . $thaimontharr[date('m',$strtotime_gov_start_work_date)] . '&nbsp;&nbsp;พ.ศ. '  . thainumber(date('Y',$strtotime_gov_start_work_date)+543)  . $space[5] . 
            'รวมระยะเวลา' . $space[1] .thainumber($result['cal_year']) . '&nbsp;ปี&nbsp;&nbsp;'.thainumber($result['cal_month']).'&nbsp;เดือน</td>
        </tr>
        <tr>
            <td colspan="2" align="left">'.'ปัจจุบันรับผิดชอบงานด้าน</td>
        </tr>
        <tr>
            <td width="20" align="left"></td>
            <td width="500" align="left">'.nl2br(thainumber($result['description'])) . '</td>
        </tr>
        <tr>
            <td colspan="2" align="left">'.'ความรู้ความสามารถพิเศษ</td>
        </tr>
        <tr>
            <td width="20" align="left"></td>
            <td width="500" align="left">'.nl2br(thainumber($result['special_skill'])) . '</td>
        </tr>
    </table>
';
$pdf->writeHTML($html, false, false, true, false, '');




// ============================== 2.ข้อมูลทั่วไป (hr_move_family) ========================================= 
if($result['header2_new_page'] == '1'){ // เช็คว่ามีการขึ้นหน้าใหม่ที่่หัวข้อนี้หรือไม่
    $pdf->AddPage('P','A4'); //P=แนวตั้ง L=แนวนอน
}

if(trim($result['current_moo']) == ''){$result['current_moo'] = '-';}
if(trim($result['current_soi']) == ''){$result['current_soi'] = '-';}
if(trim($result['current_road']) == ''){$result['current_road'] = '-';}
if(trim($result['current_tel']) == ''){$result['current_tel'] = '-';}

if(trim($result['father_age']) == ''){$result['father_age'] = '-';}
if(trim($result['father_job']) == ''){$result['father_job'] = '-';}
if(trim($result['father_address']) == ''){$result['father_address'] = '-';}
if(trim($result['mother_age']) == ''){$result['mother_age'] = '-';}
if(trim($result['mother_job']) == ''){$result['mother_job'] = '-';}
if(trim($result['mother_address']) == ''){$result['mother_address'] = '-';}

$html = '
    <table width="100%" cellspacing="-6" cellpadding="-6" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr><td align="left" style="font-size:16px">'.$space[16].'<b>๒. <u>ข้อมูลทั่วไป</u></b></td></tr>
    </table>

    <table width="100%" cellspacing="-8" cellpadding="-8" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" width="100%" border="0" style="font-size:16px">
        <tr>
            <td colspan="2" align="left">'.$space[20].'ข้าพเจ้ามีภูมิลำเนาเดิมอยู่ที่จังหวัด'.$space[2]. $result['birth_changwat_name'].'</td>
        </tr>
        <tr>
            <td colspan="2"  align="left">'.
                'ปัจจุบันพำนักอาศัยอยู่ที่ ณ บ้านเลขที่'.$space[1]. thainumber(replace_empty($result['current_address'],'-')) . $space[3] .
                'หมู่ที่' . $space[1] . thainumber(replace_empty($result['current_moo'],'-')) . $space[3] .
                'ตรอก/ซอย' . $space[1] . thainumber(replace_empty($result['current_soi'],'-')) . $space[3] .
                'ถนน'.$space[1]. thainumber(replace_empty($result['current_road'],'-')) . $space[3] .
            '</td>
        </tr>
        <tr>
            <td colspan="2"  align="left">'.                
                'ตำบล/แขวง' . $space[1] . thainumber(replace_empty($result['current_tambon'],'-')) . $space[3] .
                'อำเภอ/เขต' . $space[1] . thainumber(replace_empty($result['current_ampur'],'-')) . $space[3] .
                'จังหวัด'.$space[1]. thainumber(replace_empty($result['current_changwat'],'-')) . $space[3] .
                'รหัสไปรษณีย์' . $space[1] . thainumber(replace_empty($result['current_zipcode'],'-')) . $space[3] .
            '</td>
        </tr>
        <tr>
            <td colspan="2"  align="left">'.                
                'โทรศัพท์' . $space[1] . thainumber(replace_empty($result['current_tel'],'-')) . $space[3] .
                'ซึ่งเป็น' . $space[1] . thainumber(replace_empty($result['home_type_name'],'-')) . $space[3] .
            '</td>
        </tr>
        <tr>
            <td colspan="2"  align="left">'.                
                'ข้าพเจ้ามีพี่น้องร่วมบิดามารดาที่ยังมีชีวิต' . $space[1] . thainumber(replace_empty($result['brother_number'],'-')) . $space[1] . 'คน' . $space[3] .
                'ข้าพเจ้าเป็นบุตรคนที่' . $space[1] . thainumber(replace_empty($result['my_number'],'-')) . $space[3] .
            '</td>
        </tr>
        <tr>
            <td colspan="2"  align="left">'.
                'สถานภาพปัจจุบัน บิดามารดา' . $space[3] . $result['parent_type_name'] . $space[1] . thainumber($result['hr_move_family_parent_with_child']) .
            '</td>
        </tr>
        <tr>
            <td colspan="2"  align="left">'.
                'บิดา&nbsp;&nbsp;' . 'อายุ&nbsp;' . thainumber(replace_empty($result['father_age'],'-')) . '&nbsp;ปี&nbsp;&nbsp;อาชีพ&nbsp;' . thainumber(replace_empty($result['father_job'],'-')) . '&nbsp;&nbsp;ที่อยู่&nbsp;' . thainumber(replace_empty($result['father_address'],'-')) .
            '</td>
        </tr>
        <tr>
            <td colspan="2"  align="left">'.
                'มารดา&nbsp;&nbsp;' . 'อายุ&nbsp;' . thainumber(replace_empty($result['mother_age'],'-')) . '&nbsp;ปี&nbsp;&nbsp;อาชีพ&nbsp;' . thainumber(replace_empty($result['mother_job'],'-')) . '&nbsp;&nbsp;ที่อยู่&nbsp;' . thainumber(replace_empty($result['mother_address'],'-')) .
            '</td>
        </tr>
    </table>
';
$pdf->writeHTML($html, false, false, true, false, '');





// ============================== 3.สถานภาพครอบครัว (hr_move_family) ========================================= 
if($result['header3_new_page'] == '1'){ 
    $pdf->AddPage('P','A4'); //P=แนวตั้ง L=แนวนอน
}

if(trim($result['partner_moo']) == ''){$result['partner_moo'] = '-';}
if(trim($result['partner_soi']) == ''){$result['partner_soi'] = '-';}
if(trim($result['partner_road']) == ''){$result['partner_road'] = '-';}
if(trim($result['partner_tel']) == ''){$result['partner_tel'] = '-';}

$show_child_number = 'ไม่มี';
$show_child_age = '-';
$show_child_cover = '';

if($result['child_number'] > 0){ //แปลว่ามีจำนวนบุตร
    $show_child_number = thainumber($result['child_number']) . '&nbsp;คน';
    $show_child_age = thainumber($result['child_age']);
    $show_child_cover = replace_empty($result['child_cover'],'-');
}

$show_partner_age = '';
if($result['partner_age'] > 0){
    $show_partner_age = thainumber($result['partner_age']) .'&nbsp;ปี' ;
}

$html = '
    <table width="100%" cellspacing="-6" cellpadding="-6" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr><td align="left" style="font-size:16px">'.$space[16].'<b>๓. <u>สถานภาพครอบครัว</u></b></td></tr>
    </table>

    <table width="100%" cellspacing="-8" cellpadding="-8" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" width="100%" border="0" style="font-size:16px">
        <tr>
            <td colspan="2" align="left">'.$space[20].'สถานภาพปัจจุบัน'.$space[3]. $result['marry_type_name'] . ' ' . $result['hr_move_marry_type_other'] . 
            '</td>
        </tr>
        <tr>
            <td colspan="2" align="left">จำนวนบุตร'.$space[1]. $show_child_number .  
            $space[4].'อายุบุตร&nbsp; '. $space[1] . replace_empty($show_child_age,'-') .'</td>
        </tr>
        <tr>
            <td colspan="2" align="left">บุตรอยู่ในความดูแลของ'.$space[2]. thainumber($show_child_cover) .'</td>
        </tr>
        <tr>
            <td colspan="2" align="left">สามี/ภรรยาของข้าพเจ้าชื่อ'.$space[2]. replace_empty($result['partner_name'],'-') .$space[3]. 'อายุ' .$space[1]. thainumber($show_partner_age) .'</td>
        </tr>
        <tr>
            <td colspan="2" align="left">สถานที่ทำงาน'.$space[3]. thainumber(replace_empty($result['partner_work'],'-')) . $space[3]. 'โทรศัพท์'.$space[1].thainumber(replace_empty($result['partner_work_tel'],'-')) .'</td>
        </tr>
        <tr>
            <td colspan="2"  align="left">'.
                'คู่สมรสพำนักอาศัย ณ บ้านเลขที่'.$space[1]. thainumber(replace_empty($result['partner_address'],'-')) . $space[3] .
                'หมู่ที่' . $space[1] . thainumber(replace_empty($result['partner_moo'],'-')) . $space[3] .
                'ตรอก/ซอย' . $space[1] . thainumber(replace_empty($result['partner_soi'],'-')) . $space[3] .
                'ถนน'.$space[1]. thainumber(replace_empty($result['partner_road'],'-')) . $space[3] .
            '</td>
        </tr>
        <tr>
            <td colspan="2"  align="left">'.
                'ตำบล/แขวง' . $space[1] . thainumber(replace_empty($result['partner_tambon'],'-')) . $space[3] .
                'อำเภอ/เขต' . $space[1] . thainumber(replace_empty($result['partner_ampur'],'-')) . $space[3] .
                'จังหวัด'.$space[1]. thainumber(replace_empty($result['partner_changwat'],'-')) . $space[3] .
                'รหัสไปรษณีย์' . $space[1] . thainumber(replace_empty($result['partner_zipcode'],'-')) . $space[3] .
            '</td>
        </tr>
        <tr>
            <td colspan="2"  align="left">'.                
                'โทรศัพท์' . $space[1] . thainumber($result['partner_tel']) . $space[3] .
            '</td>
        </tr>
    </table>
';
$pdf->writeHTML($html, false, false, true, false, '');




// ============================== 4.คุณวุฒิการศึกษา (hr_move_meeting) ========================================= 
if($result['header4_new_page'] == '1'){ // เช็คว่ามีการขึ้นหน้าใหม่ที่่หัวข้อนี้หรือไม่
    $pdf->AddPage('P','A4'); //P=แนวตั้ง L=แนวนอน
}
$html = '
    <table width="100%" cellspacing="-6" cellpadding="-6" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr><td align="left" style="font-size:16px">'.$space[16].'<b>๔. <u>คุณวุฒิการศึกษา</u></b></td></tr>
    </table>
    <table width="100%" cellspacing="-8" cellpadding="-8" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" width="100%" border="0" style="font-size:16px">
    ';
    $check_education = 0; //ถ้าเป็น 0 ไปจนจบแปลว่า ไม่มีข้อมูลคุณวุฒิการศึกษา
    for($i=1;$i<=5;$i++){
        if(trim($result['educate_vut_'.$i]) != ''){
            $check_education++;
            $html .= '
                <tr>
                    <td align="left">'.thainumber($i).'. คุณวุฒิการศึกษาที่ได้รับ '. thainumber($result['educate_vut_'.$i]) . $space[1] . '<br>'. $space[3] .'สาขา ' . thainumber($result['educate_branch_'.$i]) . $space[1] . ' วันที่จบการศึกษา ' . thainumber(dateintertothaifull($result['educate_graduation_day_'.$i], 'full')) . '</td>
                </tr>
            ';
        }
    }
    if($check_education == 0){ //กรณี =0 หมายถึง ไม่มีข้อมูล
        $html .= '
            <tr>
                <td align="left">'.$space[16].'ไม่มี</td>
            </tr>
        ';
    }
$html .= '</table>';
$pdf->writeHTML($html, false, false, true, false, '');




// ============================== 5. การผ่านหลักสูตรการฝึกอบรมของสำนักงานอัยการสูงสุด (hr_move_meeting) ==================================
// เช็คว่ามีการขึ้นหน้าใหม่ที่่หัวข้อนี้หรือไม่
if($result['header5_new_page'] == '1'){
    $pdf->AddPage('P','A4'); //P=แนวตั้ง L=แนวนอน
}
$html = '
    <table width="100%" cellspacing="-6" cellpadding="-6" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr><td align="left" style="font-size:16px">'.$space[16].'<b>๕. <u>การผ่านหลักสูตรการฝึกอบรมของสำนักงานอัยการสูงสุด</u></b></td></tr>
    </table>
    <table width="100%" cellspacing="-8" cellpadding="-8" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" width="100%" border="0" style="font-size:16px">
    ';
    $check_meeting = 0; //ถ้าเป็น 0 ไปจนจบแปลว่า ไม่มีข้อมูลคุณวุฒิการศึกษา
    for($i=1;$i<=5;$i++){
        if(trim($result['meeting_model_'.$i]) != '' || trim($result['meeting_name_'.$i]) != ''){
            $result['meeting_model_'.$i] = replace_empty($result['meeting_model_'.$i],' -');
            $check_meeting++;
            $html .= '
                <tr>
                    <td width="16" align="left">'.thainumber($i).'.'.'</td>
                    <td width="500" align="left">รุ่นที่ '. thainumber(replace_empty($result['meeting_model_'.$i],'-')) . $space[1] . ' ชื่อหลักสูตร ' . thainumber(replace_empty($result['meeting_name_'.$i],'-')) . '</td>
                </tr>
            ';
        }
    }
    if($check_meeting == 0){ //กรณี =0 หมายถึง ไม่มีข้อมูล
        $html .= '
            <tr>
                <td align="left">'.$space[20].'ไม่มี</td>
            </tr>
        ';
    }
$html .= '</table>';
$pdf->writeHTML($html, false, false, true, false, '');



// ============================== 6. การผ่านหลักสูตรการฝึกอบรมจากหน่วยงานภายนอกที่สำคัญ (hr_move_meeting) ==================================
// เช็คว่ามีการขึ้นหน้าใหม่ที่่หัวข้อนี้หรือไม่
if($result['header6_new_page'] == '1'){
    $pdf->AddPage('P','A4'); //P=แนวตั้ง L=แนวนอน
}
$html = '
    <table width="100%" cellspacing="-6" cellpadding="-6" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr><td align="left" style="font-size:16px">'.$space[16].'<b>๖. <u>การผ่านหลักสูตรการฝึกอบรมจากหน่วยงานภายนอกที่สำคัญ</u></b></td></tr>
    </table>
    <table width="100%" cellspacing="-8" cellpadding="-8" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" width="100%" border="0" style="font-size:16px">
    ';
    $check_meeting = 0; //ถ้าเป็น 0 ไปจนจบแปลว่า ไม่มีข้อมูลคุณวุฒิการศึกษา
    for($i=1;$i<=5;$i++){
        if(trim($result['meeting_model_other_'.$i]) != '' || trim($result['meeting_name_other_'.$i]) != ''){
            $result['meeting_model_other_'.$i] = replace_empty($result['meeting_model_other_'.$i],' -');
            $check_meeting++;
            $html .= '
                <tr>
                    <td width="16" align="left">'.thainumber($i).'.'.'</td>
                    <td width="500" align="left">รุ่นที่ '. thainumber(replace_empty($result['meeting_model_other_'.$i],'-')) . $space[1] . ' ชื่อหลักสูตร ' . thainumber(replace_empty($result['meeting_name_other_'.$i],'-')) . '</td>
                </tr>
            ';
        }
    }
    if($check_meeting == 0){ //กรณี =0 หมายถึง ไม่มีข้อมูล
        $html .= '
            <tr>
                <td align="left">'.$space[20].'ไม่มี</td>
            </tr>
        ';
    }
$html .= '</table>';
$pdf->writeHTML($html, false, false, true, false, '');



// ============================== 7.ประวัติการรับราชการในสำนักงานอัยการสูงสุด (hr_move_history) ========================================= 
// เช็คว่ามีการขึ้นหน้าใหม่ที่่หัวข้อนี้หรือไม่
if($result['header7_new_page'] == '1'){
    $pdf->AddPage('P','A4'); //P=แนวตั้ง L=แนวนอน
}

$html_history = '';
$arr_show_gov = array();
for($i=1;$i<=3;$i++){    
    if($result['gov_name_'.$i] != ''){
        if($result['gov_id_'.$i] == '99999999'){
            $result['gov_name_'.$i] = trim($result['gov_other_name_'.$i]);
        }
        $html_history .= '
            <tr>
                <td colspan="2"  align="left">'.                
                    thainumber($i) . '.' . $space[1] . thainumber($result['gov_name_'.$i]) . '<br>' .  $space[4] .
                    'ตั้งแต่' . $space[1] . thainumber(dateintertothaifull($result['start_date_'.$i])) . $space[3] . 'ถึง' . $space[1]. thainumber(dateintertothaifull($result['stop_date_'.$i])) . $space[3] .
                '</td>
            </tr>
            <tr>
                <td colspan="2"  align="left">'.
                    $space[4] .'ในตำแหน่ง' . $space[1] . thainumber($result['position_name_'.$i]) . $space[3] .
                '</td>
            </tr>
        ';
    }
}
if(trim($html_history) == ''){
    $html_history .= '
        <tr>
            <td colspan="2" align="left">'.$space[20].'ไม่มี</td>
        </tr>
    ';
}

$html = '
    <table width="100%" cellspacing="-6" cellpadding="-6" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr><td align="left" style="font-size:16px">'.$space[16].'<b>๗. <u>ประวัติการรับราชการในสำนักงานอัยการสูงสุด</u></b></td></tr>
    </table>
    <table width="100%" cellspacing="0" cellpadding="0" width="100%" border="0" style="font-size:16px">
        '.thainumber($html_history).'
    </table>
';
$pdf->writeHTML($html, false, false, true, false, '');



// ============================== 8.ตำแหน่งที่จะโยกย้ายหรือย้ายต่างสายงานในกลุ่มตำแหน่งเดียวกัน (hr_move_target) ========================================= 
// เช็คว่ามีการขึ้นหน้าใหม่ที่่หัวข้อนี้หรือไม่
if($result['header8_new_page'] == '1'){
    $pdf->AddPage('P','A4'); //P=แนวตั้ง L=แนวนอน
}

//1.กรณีโยกย้ายไปสำนักงานแห่งใหม่ในตำแหน่งเดิม ระบบจะบันทึกตำแหน่งปัจจุบันอัตโนมัติ
//2.กรณีย้ายต่างสายงานในกลุ่มตำแหน่งเดียวกัน ให้เลือกตำแหน่งที่ขอย้ายสายงาน (เฉพาะข้าราชการธุรการ)
$position_move_type_name = ''; //ประเภทของการขอย้ายสายงาน
if($result['position_move_type_id'] == 1){
    $position_move_type_name = 'โยกย้ายไปสำนักงานแห่งใหม่ในตำแหน่งเดิม';

    //กรณีที่เป็น 1 จะไม่สนใจที่เก็บไว้ในฐานข้อมูล ว่าเก็บข้อมูล ระดับใดไว้ จะให้ใช้ข้อมูลจากระดับในข้อที่ 1.ตำแหน่งหน้าที่ในปัจจุบัน
    if($result['person_type_id'] == 2){ //กรณีเฉพาะ ขรก.ธุรการ
        $result['target_position_level_name'] = thainumber($result['position_level_name']);
    }

}else{
    $position_move_type_name = 'ย้ายต่างสายงานในกลุ่มตำแหน่งเดียวกัน';
}

$html = '
    <table width="100%" cellspacing="-6" cellpadding="-6" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr><td align="left" style="font-size:16px">'.$space[16].'<b>๘. <u>ตำแหน่งที่จะโยกย้ายหรือย้ายต่างสายงานในกลุ่มตำแหน่งเดียวกัน</u></b></td></tr>
    </table>
    <table width="100%" cellspacing="-8" cellpadding="-8" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" width="100%" border="0" style="font-size:16px">
        <tr>
            <td align="left">'.$position_move_type_name.' : ' . thainumber($result['target_position_name']) . thainumber($result['target_position_level_name']) .'</td>
        </tr>
    </table>
';
$pdf->writeHTML($html, false, false, true, false, '');



// ============================== 9.ข้อมูลประกอบการพิจารณาโยกย้ายให้ไปปฏิบัติราชการ (hr_move_target) ========================================= 

// เช็คว่ามีการขึ้นหน้าใหม่ที่่หัวข้อนี้หรือไม่
if($result['header9_new_page'] == '1'){
    $pdf->AddPage('P','A4'); //P=แนวตั้ง L=แนวนอน
}

$max_target = 7;

$arr_show_target = array();
for($i=1;$i<=$max_target;$i++){

    if($result['changwat_id_'.$i] != '' && $result['changwat_id_'.$i] != '-'){

        $changwat_name = '';
        $building_name = '';
        $ampur_name = '';

        foreach($allchangwat as $changwat){
            if($result['changwat_id_'.$i] == $changwat['changwat_id']){
                if($result['changwat_id_'.$i] == '00'){ //กรณีเลือก ส่วนกลาง
                    $changwat_name = $changwat['name'];
                }else if($result['changwat_id_'.$i] < 100){ //เป็นจังหวัด
                    $changwat_name = 'จังหวัด ' . $changwat['name'];
                }else if($result['changwat_id_'.$i] > 100){ //เป็นการเลือกภาค
                    $changwat_name = $changwat['name'];
                }
                break;
            }
        }

        $building_name = '';
        $ampur_name = '';

        if($result['changwat_id_'.$i] == '00'){ //เลือก ส่วนกลาง จะหา อาคาร
            if($result['building_id_'.$i] != ''){
                foreach($allbuilding as $building){
                    if($result['building_id_'.$i] == $building['building_id']){
                        $building_name = '&nbsp;&nbsp;อาคาร&nbsp;' . $building['name'];
                        break;
                    }
                }
            }
        }else{ //กรณีเลือก จังหวัด จะหา อำเภอ
            if($result['ampur_id_'.$i] != ''){
                foreach($allampur as $ampur){
                    if($result['ampur_id_'.$i] == $ampur['ampur_id']){
                        if($ampur['ampur_id'] >= 10001 && $ampur['ampur_id'] <= 10009){ //จะเป็นการเลือกภาค ทุกหน่วยงานในภาค 1-9
                            $ampur_name = '&nbsp;&nbsp;' . $ampur['name'];
                        }elseif($ampur['ampur_id'] == '9999'){ //ทุกหน่วยงานในจังหวัด
                            $ampur_name = '&nbsp;&nbsp;' . $ampur['name'];
                        }else{
                            $ampur_name = '&nbsp;&nbsp;อำเภอ&nbsp;' . $ampur['name'];
                        }
                        break;
                    }
                }
            }
        }        

        // ส่วนของชื่อสำนักงาน 1-3 ถ้ามีการระบุ
        $html_gov_name = '';
        if($result['gov_id_active_'.$i] == '1'){ //0=ไม่ประสงค์ระบุสำนักงาน 1=ประสงค์ระบุสำนักงาน
            $gov_number = 1; //ไว้แสดงอันดับ หน้า หน่วยงาน
            for($q=1;$q<=3;$q++){
                foreach($allgov as $gov){
                    if($result['gov_id_'.$i.'_'.$q] == $gov['gov_id']){
                        $html_gov_name .= '<br>'.$space[5] . $i . '.' . $gov_number++ . '. ' . $gov['name'] . ' (' . $gov['name_short'] . ')'; //1.1 ชื่อหน่วยงาน
                        break;
                    }
                }                
            }
            // if($gov_number > 1) { //หมายความว่ามีการระบุหน่วยงาน ดังนั้นจะต้องลบ <br> ด้านหลัง
            //     $html_gov_name = substr($html_gov_name,0,-4);
            // }
        }
      
        $arr_show_target[$i] = '
            <tr>
                <td colspan="2"  align="left">'.                
                    '<b>'.$i .'.'. $space[1] . $changwat_name . $building_name . $ampur_name . '</b>' . $html_gov_name .
                '</td>
            </tr>
        ';

    }

}

$show_all_gov = '';
for($i=1;$i<=$max_target;$i++){
    if(!empty($arr_show_target[$i])){ 
        $show_all_gov .= thainumber($arr_show_target[$i]);
    }
}

//ตรวจสอบว่า ผู้ใช้งานได้ ติ๊ก
$confirm_stay_type_name = '';
if($result['confirm_stay_type'] == 1){
    $confirm_stay_type_name = '<tr><td><b>'.$space[4].'กรณีไม่ได้รับการพิจารณาตามข้อมูลประกอบการโยกย้าย ขอปฏิบัติราชการ ณ สำนักงานเดิม</b></td></tr>';
}

$html = '
    <table width="100%" cellspacing="-5" cellpadding="-5" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr><td align="left" style="font-size:16px">'.$space[16].'<b>๙. <u>หน่วยงานที่ใช้เป็นข้อมูลประกอบการพิจารณา มีดังนี้</u></b></td></tr>
    </table>    
    <table width="100%" cellspacing="0" cellpadding="0" width="100%" border="0" style="font-size:16px">
        '.$show_all_gov.'
    </table>
    <table width="100%" cellspacing="0" cellpadding="0" width="100%" border="0" style="font-size:16px">
        '.$confirm_stay_type_name.'
    </table>
';
$pdf->writeHTML($html, false, false, true, false, '');



// ============================== 10.เหตุผลประกอบการพิจารณา (hr_move_detail) ========================================= 
// เช็คว่ามีการขึ้นหน้าใหม่ที่่หัวข้อนี้หรือไม่
if($result['header10_new_page'] == '1'){
    $pdf->AddPage('P','A4'); //P=แนวตั้ง L=แนวนอน
}

$description = str_replace(' ','&nbsp;',$result['move_detail_description']);

$html = '
    <table width="100%" cellspacing="-2" cellpadding="-2" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr><td align="left" style="font-size:16px">'.$space[16].'<b><u>เหตุผลประกอบการพิจารณา</u></b></td></tr>
    </table>
    <table width="100%" cellspacing="0" cellpadding="0" width="100%" border="0" style="font-size:16px">
        <tr>
            <td colspan="2" align="left">'.nl2br(thainumber($description)).'</td>
        </tr>
    </table>

    <table width="100%" cellspacing="-3" cellpadding="-3" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr><td align="left" style="font-size:16px">'.$space[16].'จึงกราบเรียนมาเพื่อโปรดพิจารณา</td></tr>
    </table>
    <table width="100%" cellspacing="3" cellpadding="3" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr>
            <td align="" width="120" style="font-size:16px"></td>
            <td align="center" width="280" style="font-size:16px">
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(ลงชื่อ) ............................................ ผู้แจ้งข้อมูล<br>
                '.$result['prename'].$result['fname'].' '.$result['lname'].'<br>
                '.thainumber($result['position_name'].$result['position_level_name']).'
            </td>
            <td align="" width="80" style="font-size:16px"></td>
        </tr>
    </table>
';
$pdf->writeHTML($html, true, true, true, true, '');



// $pdf->SetMargins(10, 15, 10, true); //left top right
$pdf->AddPage('P','A4'); //P=แนวตั้ง L=แนวนอน

// ============================== 10.ลายเซ็น (hr_move_detail) ========================================= 
$html = '
<table width="100%" cellspacing="0" cellpadding="0" border="0">
<tr><td align="left"><img src="assets/form/form_boss_signature.png"></td></tr>
</table>
';
$pdf->writeHTML($html, false, false, true, false, '');

/*
$html = '
    <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tr><td align="left" style="font-size:16px"><b><u>ความเห็นผู้บังคับบัญชาตามลำดับขั้น</u></b></td></tr>
    </table>

    <table width="100%" cellspacing="-5" cellpadding="-5" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" width="100%" border="0" style="font-size:12px">
        <tr>
            <td width="200" align="center">..............................................................................................<br>
..............................................................................................<br>
..............................................................................................<br>
..............................................................................................
            </td>
            <td width="110" align="left"></td>
            <td width="200" align="center">..............................................................................................<br>
..............................................................................................<br>
..............................................................................................<br>
..............................................................................................
            </td>
        </tr>
    </table>

    <table width="100%" cellspacing="-2" cellpadding="-2" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" width="100%" border="0" style="font-size:16px">
        <tr>
            <td width="200" align="center">ลงชื่อ <span style="font-size:12px">.............................................................</span><br>
(<span style="font-size:12px">...........................................................</span>)<br>
ตำแหน่ง <span style="font-size:12px">.....................................................</span><br>
วันที่ <span style="font-size:12px">..............................................................</span>
            </td>
            <td width="110" align="left"></td>
            <td width="200" align="center">ลงชื่อ <span style="font-size:12px">.............................................................</span><br>
(<span style="font-size:12px">...........................................................</span>)<br>
ตำแหน่ง <span style="font-size:12px">.....................................................</span><br>
วันที่ <span style="font-size:12px">..............................................................</span>
            </td>
        </tr>
    </table>
';
$pdf->writeHTML($html, false, false, true, false, '');

$html = ' 
    <table width="100%" cellspacing="-1" cellpadding="-1" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" width="100%" border="0" style="font-size:12px">
        <tr>
            <td width="510" align="center">
                <span style="font-size:12px">...................................................................................</span><br>
                <span style="font-size:12px">...................................................................................</span><br>
                <span style="font-size:12px">...................................................................................</span><br>
                <span style="font-size:12px">...................................................................................</span><br>
            </td>
        </tr>
    </table>

    <table width="100%" cellspacing="-5" cellpadding="-5" ><tr><td></td></tr></table>
    <table width="100%" cellspacing="0" cellpadding="0" width="100%" border="0" style="font-size:16px">
        <tr>
            <td width="510" align="center">ลงชื่อ <span style="font-size:12px">.............................................................</span><br>
                (<span style="font-size:12px">...........................................................</span>)<br>
                ตำแหน่ง <span style="font-size:12px">.....................................................</span><br>
                วันที่ <span style="font-size:12px">..............................................................</span>
            </td>
        </tr>
    </table>
';
$pdf->writeHTML($html, false, false, true, false, '');
*/


// exit();


// reset pointer to the last page
$pdf->lastPage();
// ---------------------------------------------------------

ob_end_clean();

//Close and output PDF document
$filename = 'แบบฟอร์มขอย้าย-'. $_COOKIE[PREFIX_COOKIE."PERSONFNAME"] . '-' .  time() . ".pdf";
$pdf->Output($filename, 'I');