<?php
//============================================================+
// File name   : example_003.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 003 for TCPDF class
//               Custom Header and Footer
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Custom Header and Footer
 * @author Nicola Asuni
 * @since 2008-03-04
 */

// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');
require_once('../../connect_dbo.php');
require_once('../../main_function.php');

			$cutID  = $_COOKIE["IDOrder"];

			// $DateCut  = ChangeDate($_POST['DateCut']);


			$sqlstr = "SELECT c.idnum,c.id_order,c.icode,p.product_type_name,c.oder_date,CONCAT(f.office,'  ',f.office_under) AS office,st.staff_name,sf.staff_name,c.BillOrder,c.yaerOrder,f.office_under
			FROM db_cutOrder c 
			LEFT JOIN db_typeProduct p ON (p.id_product_type = c.id_typeProduct)
			LEFT JOIN db_office f ON (f.id_ofiice = c.id_ofiice)
			LEFT JOIN db_staff st ON (st.id_staff = c.id_person)
			LEFT JOIN db_staff sf ON (sf.id_staff = c.id_staff)
			WHERE c.Id_order = '".$cutID."' AND c.BillOrder != ''
			GROUP BY c.id_order";
			$sth = $dbh->prepare($sqlstr);
			$sth->execute();
			while ($row = $sth->fetch(PDO::FETCH_NUM, PDO::FETCH_ORI_NEXT)) {

                $Id_order = $row[1];
                $productname = $row[3];
				$oder_date = $row[4];
				$office = $row[5];
				$Person = $row[6];
				$staff_name = $row[7];
				$BillOrder = $row[9].sprintf("%04d",($row[8]));
				$office_under = $row[10];
			}

            


// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

	//Page header
	public function Header() {

		global $productname;
		global $oder_date ;
		global $office;
		global $BillOrder;
		// Logo
		$image_file = K_PATH_IMAGES.'LOGO_SASUK.jpg';
		$this->Image($image_file, 10, 5, 18, '', 'jpg', '', 'T', false, 300, '', false, false, 0, false, false, false);
		// Set font
		$this->SetFont('thsarabunnew', 'B', 24);
		// Title
		$this->SetY(12);
		$this->Cell(0, 25, 'ใบสั่งจ่ายเวชภัณฑ์', 0, false, 'C', 0, '', 0, false, 'M', 'M');

		$this->SetY(20);
		$this->SetFont('thsarabunnew', 'B', 15);
		$this->Cell(0, 35, 'งานบริหารคลังเวชภัณฑ์  กลุ่มงานเภสัชกรรม  โรงพยาบาลโพนนาแก้ว', 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetY(27);
		$this->Cell(0, 35, 'ใบเบิกเวชภัณฑ์เลขที่  '.$BillOrder.'   วันที่  '.datethaifull($oder_date).' คลัง '.$productname.'  หน่วยเบิก  '.$office, 0, false, 'C', 0, '', 0, false, 'M', 'M');
	}

	// Page footer
	public function Footer() {
		// Position at 15 mm from bottom
		$this->SetY(-10);
		// Set font
		$this->SetFont('thsarabunnew', '', 12);
		// Page number
        $this->Cell(67, -10, 'พิมพ์จากระบบเมื่อ : '.datethaifull(date('Y-m-d')).'   '.date("H:i:s").' น.', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(220, -10, 'หน้า : '. $this->getAliasNumPage() .'/'. $this->getAliasNbPages() , 0, false, 'R', 0, '', 0, false, 'T', 'M');
	}

}

// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetTitle('ใบสั่งจ่ายเวชภัณฑ์คลัง '.$productname.'  หน่วยเบิก  '.$office);
// $pdf->SetSubject('TCPDF Tutorial');
// $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

$top = 31;
$left = 10;
$right = 10;

$pdf->SetMargins($left, $top, $right);
$pdf->SetAutoPageBreak(TRUE, 12.3); //Auto Set Margin Bottom

$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(-10);


// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('thsarabunnew', 'B', 14);

// add a page
$pdf->AddPage('L','A4');

// ---------------------------------------------------------


$html = '<table width="978" border="1">
<thead>
	<tr>
		<th width="22" rowspan="2" align="center" valign="middle">ที่</th>
		<th width="313"rowspan="2" align="center" valign="middle">รายการ</th>
		<th width="63" rowspan="2" align="center" valign="middle">หน่วยนับ</th>
		<th width="89" rowspan="2" align="center" valign="middle">จำนวนเบิก</th>
		<th width="86" rowspan="2" align="center" valign="middle">อนุมัติจ่าย</th>
		<th width="83" rowspan="2" align="center" valign="middle">ราคา/หน่วย</th>
		<th width="85" rowspan="2" align="center" valign="middle">ราคารวม</th>
		<th width="237" colspan="3" align="center" valign="middle">เวชภัณฑ์</th>
	</tr>
	<tr>
		<th width="81" align="center" valign="middle">Lot No.</th>
		<th width="79" align="center" valign="middle">exp.date</th>
		<th width="77" align="center" valign="middle">คงหลือ</th>
	</tr>
</thead>
<tbody>';

// set font
$pdf->SetFont('thsarabunnew', 'B', 12);

$n = 1;

$total = 0;

$sqlstr2 = "SELECT c.id_order,c.icode,m.`name`,m.strength,m.units,c.id_typeProduct,c.quantity_order,c.oder_date,Medibalance,c.approve,c.totalcost,m.locker FROM db_cutOrder c
LEFT JOIN db_medicalsup m ON (m.icode = c.icode)
WHERE c.Id_order = '".$cutID."' AND c.BillOrder != '' AND c.numOrder !=''";
$sth2 = $dbh->prepare($sqlstr2);
$sth2->execute();

while ($row2 = $sth2->fetch(PDO::FETCH_NUM, PDO::FETCH_ORI_NEXT)) {

	$icode = $row2[1];
	$Mname = $row2[2];
	$units = $row2[4];
	$quantity_order = $row2[6];
	$Medibalance = $row2[8];
	$approve  = $row2[9];
	$totalcost = $row2[10];
	$loker = $row2[11];


$html .= '<tr>
      <td width="22" align="center">'.$n.'</td>
      <td width="313">&nbsp;&nbsp;'.$Mname.'</td>
      <td width="63" align="center">'.$units.'</td>
      <td width="89" align="center">'.number_format($quantity_order).'</td>
      <td width="86" align="center">'.number_format($approve).'</td>
      <td width="83" align="right">'.number_format($totalcost / $approve,3).'&nbsp;&nbsp;</td>
      <td width="85" align="right">'.number_format($totalcost,2).'&nbsp;&nbsp;</td>
      <td width="81" align="center">'.$loker.'</td>
      <td width="79" align="right"></td>
      <td width="77" align="center">'.number_format($Medibalance,0).'</td>
    </tr>';

	$sqlstr3 = "SELECT c.id_Product,d.productname,c.quantityCut,c.cost,c.lot_no,c.date_exp,c.lotbalance FROM db_Cutstock c 
	LEFT JOIN db_drug d ON (d.id_Product = c.id_Product)
	WHERE c.id_order = '".$cutID."' AND c.icode = '".$icode."' ORDER BY c.date_exp ASC";
	$sth3 = $dbh->prepare($sqlstr3);
	$sth3->execute();

	while ($row3 = $sth3->fetch(PDO::FETCH_NUM, PDO::FETCH_ORI_NEXT)) {

		$total = $total + ($row3[3] * $row3[2]);

		$html .= '<tr>
		<td width="22" align="center"></td>
		<td width="313">&nbsp;&nbsp;&nbsp;&nbsp;- &nbsp;'.$row3[1].'</td>
		<td width="63" align="center">'.$units.'</td>
		<td width="89" align="center"></td>
		<td width="86" align="center">'.$row3[2].'</td>
		<td width="83" align="right">'.number_format($row3[3],3).'&nbsp;&nbsp;</td>
		<td width="85" align="right">'.number_format($row3[3] * $row3[2],2).'&nbsp;&nbsp;</td>
		<td width="81" align="center">'.$row3[4].'</td>
		<td width="79" align="center">'.convdate($row3[5]).'</td>
		<td width="77" align="center">'.number_format($row3[6],0).'</td>
		</tr>';

	}
		

	$n++;
}

$html .= '	<tr>
	<td  colspan="5" align="center" width="573">'.Convert2thai($total).'</td>
	<td width="83"  align="center">รวมเป็นเงิน</td>
	<td width="85" align="right">'.number_format($total,2).'&nbsp;&nbsp;</td>
	<td width="237"></td>
	</tr>


  </tbody>
</table>

 
<table width="978" border="0">
  <tbody>
    <tr>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td>
		<table width="244" border="0">
		  <tbody>
			<tr>
			  <td align="center" valign="middle">&nbsp;ผู้เบิก ........................................................</td>
			</tr>
			<tr>
			  <td align="center" valign="middle">('.$Person.')</td>
			</tr>
			<tr>
			  <td align="center" valign="middle">'.$office_under.'</td>
			</tr>
		  </tbody>
		</table>
	  </td>
      <td>
		<table width="244" border="0">
		  <tbody>
			<tr>
			  <td align="center" valign="middle">&nbsp;ผู้รับ ........................................................</td>
			</tr>
			<tr>
			  <td align="center">        (..........................................................)</td>
			</tr>
			<tr>
			  <td>&nbsp;</td>
			</tr>
		  </tbody>
		</table>
	  </td>
      <td>
		<table width="244" border="0">
		  <tbody>
			<tr>
			  <td align="center" valign="middle">&nbsp;ผู้จ่าย ........................................................</td>
			</tr>
			<tr>
			  <td align="center" valign="middle">('.$_COOKIE["Name"].')</td>
			</tr>
			<tr>
			  <td>&nbsp;</td>
			</tr>
		  </tbody>
		</table>
	  </td>
      <td>
		<table width="244" border="0">
		  <tbody>
			<tr>
			  <td align="center" valign="middle">&nbsp;ผู้อนุมัติ ........................................................</td>
			</tr>
			<tr>
			  <td align="center">('.$staff_name.')</td>
			</tr>
			<tr>
			  <td align="center" valign="middle">&nbsp;หัวหน้างานบริหารคลังเวชภัณฑ์</td>
			</tr>
		  </tbody>
		</table>
	  </td>
    </tr>
  </tbody>
</table>';

$pdf->writeHTML($html, false, false, true, false, '');


//Close and output PDF document
$pdf->Output('ใบสั่งจ่ายเวชภัณฑ์ คลัง '.$productname.'  หน่วยเบิก  '.$office.'.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+


function Convert2thai($amount_number)
  {
    $amount_number = number_format($amount_number, 2, ".","");
    $pt = strpos($amount_number , ".");
    $number = $fraction = "";
    if ($pt === false) 
      $number = $amount_number;
    else
    {
      $number = substr($amount_number, 0, $pt);
      $fraction = substr($amount_number, $pt + 1);
    }
    
    $ret = "";
    $baht = ReadNumber ($number);
    if ($baht != "")
      $ret .= $baht . "บาท";
    
    $satang = ReadNumber($fraction);
    if ($satang != "")
      $ret .=  $satang . "สตางค์";
    else 
      $ret .= "ถ้วน";
    return $ret;
  } 
  function ReadNumber($number)
  {
    $position_call = array("แสน", "หมื่น", "พัน", "ร้อย", "สิบ", "");
    $number_call = array("", "หนึ่ง", "สอง", "สาม", "สี่", "ห้า", "หก", "เจ็ด", "แปด", "เก้า");
    $number = $number + 0;
    $ret = "";
    if ($number == 0) return $ret;
    if ($number >= 1000000)
    {
      $ret .= ReadNumber(intval($number / 1000000)) . "ล้าน";
      $number = intval(fmod($number, 1000000));
    }
    
    $divider = 100000;
    $pos = 0;
    while($number > 0)
    {
      $d = intval($number / $divider);
      $ret .= (($divider == 10) && ($d == 2)) ? "ยี่" : 
        ((($divider == 10) && ($d == 1)) ? "" :
        ((($divider == 1) && ($d == 1) && ($ret != "")) ? "เอ็ด" : $number_call[$d]));
      $ret .= ($d ? $position_call[$pos] : "");
      $number = $number % $divider;
      $divider = $divider / 10;
      $pos++;
    }
    return $ret;
  }

  
