<?php

include("connect_dbo.php");
include("main_function.php");

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>ระบบบริหารคลังเวชภัณฑ์ | โรงพยาบาลโพนนาแก้ว</title>

  <!-- Font Awesome Icons -->
  <link rel="stylesheet" href="plugins/fontawesome/css/all.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.css">
  <!-- Font เรียกใช้ใน css -->
  <link rel="stylesheet" href="css/fontface.css" media="screen">
  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- SweetAlert2 -->
  <link rel="stylesheet" href="plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css">
  <!-- Toastr -->
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css">
   <!-- Select2 -->
  <link rel="stylesheet" href="plugins/select2/css/select2.css">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">

  <!-- CSS file -->
  <link rel="stylesheet" href="plugins/EasyAutocomplete/easy-autocomplete.min.css">
  <!-- Additional CSS Themes file - not required-->
  <link rel="stylesheet" href="plugins/EasyAutocomplete/easy-autocomplete.themes.min.css">

  <link href="css/datepicker3.css" rel="stylesheet"> 

  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="plugins/datatables-buttons/css/buttons.bootstrap4.min.css">

</head>
<body>
  <div class="wrapper">
<div class="card">
<div class="card-body">
    <h3 align = "center" class ="tsn_b">รายการเวชภัณฑ์ใกล้หมดอายุ</h3>
    <div align = "center" class ="tsn_b text-danger">ข้อมูล ณ​ วันที่ <?php echo convdate(date("Y-m-d"))." เวลา ".date("H:i:s")." น."; ?></div>
    <table  border = "1" id="ReportData" class="table table-bordered table-striped table-hover row-border table-head-fixed text-nowrap tsn_b">    
    <thead class="tsn_b"><tr><th class="text-center">ที่</th><th class="text-center">รหัสเวชภัณฑ์</th><th class="text-center">รายการ</th><th class="text-center">ประเภทเวชภัณฑ์</th><th class="text-center">หมวดหมู่เวชภัณฑ์</th><th class="text-center">ชื่อทางการค้า</th><th class="text-center">รหัสสินค้า</th><th class="text-center">Lot No.</th><th class="text-center">จำนวนคงเหลือ</th><th class="text-center">หน่วยนับ</th><th class="text-center">ราคาต้นทุน</th><th class="text-center">มูลค่าคงคลัง</th><th class="text-center">อายุคงเหลือ</th><th class="text-center">วันที่หมดอายุ</th></tr></thead>              
    <tbody id="dataOrder" class ="tsn_b">

<?php

            $n = 1;

            $DateEX = "60";
            $expdate = NextDate(date('Y-m-d'),$DateEX,"D");


                $sqlstr = "SELECT i.icode,m.`name` AS mname,t.product_type_name,c.category_name,i.id_Product,d.productname,i.lot_no,i.balance,i.units,i.date_exp,i.cost FROM db_stockimport i 
                LEFT JOIN db_drug d ON (i.id_Product = d.id_Product)
                LEFT JOIN db_medicalsup m ON (i.icode = m.icode)
                LEFT JOIN db_typeProduct t ON (m.id_typeProduct = t.id_product_type )
                LEFT JOIN db_category c ON (m.id_category = c.id_category)
                WHERE i.date_exp <= '".$expdate."' AND i.balance > 0 AND i.startusOrder = '9'  AND m.id_typeProduct != '3'
                ORDER BY i.date_exp ASC";
                $sth = $dbh->prepare($sqlstr);
                $sth->execute();
                $row_count = $sth->rowCount();


            if($row_count > 0){

                while ($row = $sth->fetch(PDO::FETCH_NAMED, PDO::FETCH_ORI_NEXT)) {

                    if($row['date_exp'] <= date('Y-m-d')){

                        $ex = "<font color = 'red'>หมดอายุ</font>";
                        $class = "class = 'text-danger'";

                    }else
                    {
                        $ex = day_Diff($row['date_exp']);
                        $class = "";

                    }

                    echo('<tr '.$class.'><td align="center">'.$n++.'</td><td align="center">'.$row['icode'].'</td><td>'.$row['mname'].'</td><td>'.$row['product_type_name'].'</td><td>'.$row['category_name'].'</td><td>'.$row['productname'].'</td><td align="center">'.$row['id_Product'].'</td><td align="center">'.$row['lot_no'].'</td><td align="right">'.number_format($row['balance']).'</td><td align="center">'.$row['units'].'</td><td align="right">'.number_format($row['cost'],3).'</td><td align="right">'.number_format($row['cost'] * $row['balance'],3).'</td><td align="center">'.$ex.'</td><td align="center">'.convdate($row['date_exp']).'</td></tr>');  


                }
    
            }
            
?>

        </tbody>
        </table>
    
    </div>
    <!-- /.card-body -->
    </div>
    <!-- /.card -->
</div>

<!-- /.content -->


<!-- REQUIRED SCRIPTS -->

<!-- jQuery -->
<script src="plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.js"></script>

<!-- InputMask -->
<script src="plugins/inputmask/jquery.inputmask.min.js"></script>

<script src="js/bootstrap-datepicker.js"></script>
<script src="js/bootstrap-datepicker-thai.js"></script>
<script src="js/bootstrap-datepicker.th.js"></script>

<!-- SweetAlert2 -->
<script src="plugins/sweetalert2/sweetalert2.min.js"></script>
<!-- Toastr -->
<script src="plugins/toastr/toastr.min.js"></script>

<!-- Select2 -->
<script src="plugins/select2/js/select2.full.min.js"></script>

<!-- JS file -->
<script src="plugins/EasyAutocomplete/jquery.easy-autocomplete.min.js"></script>

<!-- DataTables  & Plugins -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="plugins/jszip/jszip.min.js"></script>
<script src="plugins/pdfmake/pdfmake.min.js"></script>
<script src="plugins/pdfmake/vfs_fonts.js"></script>
<script src="plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
<script src="plugins/datatables-fixedcolumns/js/dataTables.fixedColumns.min.js"></script>
<script src="plugins/chart.js/Chart.min.js"></script>

</body>
</html>
<script>

        $(document).ready(function(){

            setTimeout(function(){

                tableData();

            },200); 
                

        });



        function printDiv(divName) {
            var printContents = document.getElementById(divName).innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;
        }


        function tableData(){            
            
            $("#ReportData").DataTable({
                "responsive": true, "lengthChange": false, "autoWidth": true,
                "oLanguage": {
                    sSearch: "ค้นหา", 
                    
                    },

                    "language": {
                    "lengthMenu": "แสดง _MENU_ แถวต่อหน้า",
                    "zeroRecords": "ขออภัยไม่พบข้อมูล",
                    "info": "หน้าที่ _PAGE_ จาก _PAGES_",
                    "infoEmpty": "No records available",
                    "infoFiltered": "(กรองจาก _MAX_ รายการทั้งหมด)",
                    "paginate": {
                            "first":      "หน้าแรก",
                            "last":       "สุดท้าย",
                            "next":       "ถัดไป",
                            "previous":   "ก่อนหน้า"
                        }
                },   

                "buttons": [{ extend: 'copy', text: 'คัดลอก', className: 'btn-info tsn_b'}, 
                { extend: 'excel', text: 'Excel', className: 'btn-info tsn_b text-center',title:'รายงานเวชภัณฑ์ใกล้หมดอายุ', messageTop: 'โรงพยาบาลโพนนาแก้ว' },
                // { extend: 'print', text: 'พิมพ์', className: 'btn-info tsn_b text-center',orientation: 'landscape', pageSize: 'A4', title:'รายงานการรับเวชภัณฑ์เข้าคลัง', messageTop: 'โรงพยาบาลโพนนาแก้ว' }, 

                {
                        extend: "print",text: 'พิมพ์', className: 'btn-info tsn_b text-center', title:'รายงานเวชภัณฑ์ใกล้หมดอายุ', messageTop: 'โรงพยาบาลโพนนาแก้ว',
                        customize: function(win)
                        {
            
                            var last = null;
                            var current = null;
                            var bod = [];
            
                            var css = '@page { size: landscape; }',
                                head = win.document.head || win.document.getElementsByTagName('head')[0],
                                style = win.document.createElement('style');
            
                            style.type = 'text/css';
                            style.media = 'print';
            
                            if (style.styleSheet)
                            {
                            style.styleSheet.cssText = css;
                            }
                            else
                            {
                            style.appendChild(win.document.createTextNode(css));
                            }
            
                            head.appendChild(style);
                    }
                },

                { extend: "colvis", text: 'คอลัมน์', className: 'btn-info tsn_b'  } ] ,   
                

            }).buttons().container().appendTo('#ReportData_wrapper .col-md-6:eq(0)');


        }



</script>

