<?php
//============================================================+
// File name   : example_003.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 003 for TCPDF class
//               Custom Header and Footer
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Custom Header and Footer
 * @author Nicola Asuni
 * @since 2008-03-04
 */

// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');
require_once('../../connect_dbo.php');
require_once('../../main_function.php');

			//$cutID  = 'ODR-651100003';


            $cutID  = $_COOKIE["IDOrderBuy"];

			// $DateCut  = ChangeDate($_POST['DateCut']);


			$sqlstr = "SELECT b.id_Orderbuy,b.date_order,b.cost,b.quantityKPI,b.quantity_order,b.Medibalance,b.notes,b.date_import,
            p.product_type_name,c.name_company,s.staff_name,u.full_name,t.type_Purchasi,s.positions,b.startusOrder
            FROM db_buyOrder b
            INNER JOIN db_typeProduct p ON (p.id_product_type = b.id_typeProduct)
            INNER JOIN db_company c ON (c.id_company = b.id_company)
            INNER JOIN db_typePurehasi t ON (t.id_typePurchasing = b.id_typePurchasing)
            INNER JOIN db_staff s ON (s.id_staff = b.id_staff)
            INNER JOIN db_usersystem u ON (u.id_user = b.user_create)
            WHERE b.id_Orderbuy = '".$cutID."' AND b.startusOrder = '2'
            GROUP BY b.id_Orderbuy";
			$sth = $dbh->prepare($sqlstr);
			$sth->execute();
			while ($row = $sth->fetch(PDO::FETCH_NUM, PDO::FETCH_ORI_NEXT)) {

                $BillOrder = $row[0];
				$oder_date = $row[1];
                $date_import = $row[7];
				$company = $row[9];
				$Person = $row[11];
				$staff_name = $row[10];
				$productname = $row[8];
                $type_Purchasi = $row[12];
                $positions = $row[13];
			}

            


// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

	//Page header
	public function Header() {

		global $productname;
		global $oder_date ;
		global $company;
		global $BillOrder;
        global $type_Purchasi;
        global $date_import;
		// Logo
		$image_file = K_PATH_IMAGES.'LOGO_SASUK.jpg';
		$this->Image($image_file, 10, 5, 18, '', 'jpg', '', 'T', false, 300, '', false, false, 0, false, false, false);
		// Set font
		$this->SetFont('thsarabunnew', 'B', 24);
		// Title
		$this->SetY(12);
		$this->Cell(0, 25, 'ใบสั่งซื้อเวชภัณฑ์', 0, false, 'C', 0, '', 0, false, 'M', 'M');

		$this->SetY(20);
		$this->SetFont('thsarabunnew', 'B', 15);
		$this->Cell(0, 35, 'งานบริหารคลังเวชภัณฑ์  กลุ่มงานเภสัชกรรม  โรงพยาบาลโพนนาแก้ว', 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetY(26);
		$this->Cell(0, 35, 'ใบสั่งซื้อเวชภัณฑ์เลขที่  '.$BillOrder.'   วันที่  '.datethaifull($oder_date).' คลัง '.$productname.'  หน่วยสั่งซื้อ  '.$company, 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetY(32);
		$this->Cell(0, 35, 'ประเภทการสั่งซื้อ  '.$type_Purchasi.'   ประมาณการวันรับสินค้า  '.datethaifull($date_import), 0, false, 'C', 0, '', 0, false, 'M', 'M');
	}

	// Page footer
	public function Footer() {
		// Position at 15 mm from bottom
		$this->SetY(-10);
		// Set font
		$this->SetFont('thsarabunnew', '', 12);
		// Page number
        $this->Cell(67, -10, 'พิมพ์จากระบบเมื่อ : '.datethaifull(date('Y-m-d')).'   '.date("H:i:s").' น.', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(220, -10, 'หน้า : '. $this->getAliasNumPage() .'/'. $this->getAliasNbPages() , 0, false, 'R', 0, '', 0, false, 'T', 'M');
	}

}

// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetTitle('ใบสั่งซื้อเวชภัณฑ์คลัง '.$productname.'  หน่วยสั่งซื้อ  '.$company);
// $pdf->SetSubject('TCPDF Tutorial');
// $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

$top = 39;
$left = 10;
$right = 10;

$pdf->SetMargins($left, $top, $right);
$pdf->SetAutoPageBreak(TRUE, 12.3); //Auto Set Margin Bottom

$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(-10);


// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('thsarabunnew', 'B', 14);

// add a page
$pdf->AddPage('L','A4');

// ---------------------------------------------------------


$html = '<table width="976" border="1">
<thead>
	<tr style="line-height: 40px;">
		<th width="28" rowspan="2" align="center" valign="middle">ที่</th>
		<th width="300"rowspan="2" align="center" valign="middle">รายการ</th>
		<th width="80" rowspan="2" align="center" valign="middle">หน่วยนับ</th>
		<th width="84" rowspan="2" align="center" valign="middle">คงเหลือ</th>
		<th width="81" rowspan="2" align="center" valign="middle">ยอดสั่งซื้อได้</th>
		<th width="83" rowspan="2" align="center" valign="middle">จำนวนสั่งซื้อ</th>
		<th width="80" rowspan="2" align="center" valign="middle">ราคา/หน่วย</th>
		<th width="90" align="center" valign="middle">ราคารวม</th>
		<th width="155" align="center" valign="middle">หมายเหตุ</th>
	</tr>
</thead>
<tbody>';

// set font
$pdf->SetFont('thsarabunnew', 'B', 12);

 $n = 1;

 $total = 0;

$sqlstr2 = "SELECT b.id_Orderbuy,b.icode,m.`name`,m.strength,m.units,b.date_order,b.cost,b.quantityKPI,b.quantity_order,b.Medibalance,b.notes,b.date_import
FROM db_buyOrder b
INNER JOIN db_medicalsup m ON (m.icode = b.icode)
WHERE b.id_Orderbuy = '".$cutID."' AND b.startusOrder = '2'";
$sth2 = $dbh->prepare($sqlstr2);
$sth2->execute();

while ($row2 = $sth2->fetch(PDO::FETCH_NUM, PDO::FETCH_ORI_NEXT)) {

	$icode = $row2[1];
    $Mname = $row2[2];
	$strength = $row2[3];
	$units = $row2[4];
    $cost = $row2[6];
    $quantityKPI = $row2[7];
	$quantity_order = $row2[8];
	$Medibalance = $row2[9];
	$note  = $row2[10];
    $mtotal = $quantity_order * $cost;

    $total = $total + $mtotal;


$html .= '<tr style="line-height: 30px;">
      <td  width="28" align="center">'.$n.'</td>
      <td  width="300">&nbsp;'.$Mname.' '.$strength.'</td>
      <td  width="80" align="center">'.$units.'</td>
      <td  width="84" align="right">'.number_format($Medibalance).'&nbsp;&nbsp;</td>
      <td  width="81" align="right">'.number_format($quantityKPI).'&nbsp;&nbsp;</td>
      <td  width="83" align="right">'.number_format($quantity_order).'&nbsp;&nbsp;</td>
      <td  width="80" align="right">'.number_format($cost,3).'&nbsp;&nbsp;</td>
      <td  width="90" align="right">'.number_format($mtotal,3).'&nbsp;&nbsp;</td>
      <td style="line-height: 16px;" width="155" >'.$note.'</td>
    </tr>';
	$n++;
}

$html .= '	<tr style="line-height: 30px;">
	<td  colspan="8" align="center" width="656">'.Convert2thai($total).'</td>
	<td width="80"  align="center">รวมเป็นเงิน</td>
	<td width="90" align="right">'.number_format($total,2).'&nbsp;&nbsp;</td>
	<td width="155"></td>
	</tr>
  </tbody>
</table>
<table width="976" border="0">
  <tbody>
    <tr>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td>
		<table width="244" border="0">
		  <tbody>
			<tr>
			  <td align="center" valign="middle">&nbsp;ผู้สั่งซื้อ ........................................................</td>
			</tr>
			<tr>
			  <td align="center" valign="middle">('.$Person.')</td>
			</tr>
			<tr>
			  <td align="center" valign="middle"></td>
			</tr>
		  </tbody>
		</table>
	  </td>
      <td>
		<table width="244" border="0">
		  <tbody>
			<tr>
			  <td align="center" valign="middle">&nbsp;</td>
			</tr>
			<tr>
			  <td align="center"></td>
			</tr>
			<tr>
			  <td>&nbsp;</td>
			</tr>
		  </tbody>
		</table>
	  </td>
      <td>
		<table width="244" border="0">
		  <tbody>
			<tr>
			  <td align="center" valign="middle">&nbsp;</td>
			</tr>
			<tr>
			  <td align="center" valign="middle"></td>
			</tr>
			<tr>
			  <td>&nbsp;</td>
			</tr>
		  </tbody>
		</table>
	  </td>
      <td>
		<table width="244" border="0">
		  <tbody>
			<tr>
			  <td align="center" valign="middle">&nbsp;ผู้อนุมัติ ........................................................</td>
			</tr>
			<tr>
			  <td align="center">('.$staff_name.')</td>
			</tr>
			<tr>
			  <td align="center" valign="middle">&nbsp;'.$positions.'</td>
			</tr>
		  </tbody>
		</table>
	  </td>
    </tr>
  </tbody>
</table>';

$pdf->writeHTML($html, false, false, true, false, '');


//Close and output PDF document
$pdf->Output('ใบสั่งซื้อเวชภัณฑ์ คลัง '.$productname.'  หน่วยสั่งซื้อ  '.$company.'.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+


function Convert2thai($amount_number)
  {
    $amount_number = number_format($amount_number, 2, ".","");
    $pt = strpos($amount_number , ".");
    $number = $fraction = "";
    if ($pt === false) 
      $number = $amount_number;
    else
    {
      $number = substr($amount_number, 0, $pt);
      $fraction = substr($amount_number, $pt + 1);
    }
    
    $ret = "";
    $baht = ReadNumber ($number);
    if ($baht != "")
      $ret .= $baht . "บาท";
    
    $satang = ReadNumber($fraction);
    if ($satang != "")
      $ret .=  $satang . "สตางค์";
    else 
      $ret .= "ถ้วน";
    return $ret;
  } 
  function ReadNumber($number)
  {
    $position_call = array("แสน", "หมื่น", "พัน", "ร้อย", "สิบ", "");
    $number_call = array("", "หนึ่ง", "สอง", "สาม", "สี่", "ห้า", "หก", "เจ็ด", "แปด", "เก้า");
    $number = $number + 0;
    $ret = "";
    if ($number == 0) return $ret;
    if ($number >= 1000000)
    {
      $ret .= ReadNumber(intval($number / 1000000)) . "ล้าน";
      $number = intval(fmod($number, 1000000));
    }
    
    $divider = 100000;
    $pos = 0;
    while($number > 0)
    {
      $d = intval($number / $divider);
      $ret .= (($divider == 10) && ($d == 2)) ? "ยี่" : 
        ((($divider == 10) && ($d == 1)) ? "" :
        ((($divider == 1) && ($d == 1) && ($ret != "")) ? "เอ็ด" : $number_call[$d]));
      $ret .= ($d ? $position_call[$pos] : "");
      $number = $number % $divider;
      $divider = $divider / 10;
      $pos++;
    }
    return $ret;
  }

  
